/**
 * File: helpers.cc
 * Copyright (C) 2025 Tyler Triplett
 * License: GNU GPL 3.0 or later <https://www.gnu.org/licenses/gpl-3.0.html>
 *
 * This is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 */

#include "src/helpers.hh"

bool containsMap(const ArgMap& map, const ArgOr& arg)
{
        return map.find(arg.first) != map.end() ||
            map.find(arg.second) != map.end();
}

Maybe<bool> validFlag(const ArgMap& map, const ArgOr& arg)
{
        const auto f = map.find(arg.first);
        const auto s = map.find(arg.second);
        const auto end = map.end();
        if (f != end && s != end)
                return make_bad<bool>("Duplicate flags");
        if (f == end && s == end)
                return false;
        const auto c = f != end ? f : s;
        if (c->second)
                return make_bad<bool>("Flag with args " + c->first);
        return true;
}

Maybe<MapIt> argToIter(const ArgMap& map, const ArgT& arg)
{
        const auto leftPtr = map.find(std::get<0>(arg));
        const auto rightPtr = map.find(std::get<1>(arg));
        const auto& name = std::get<2>(arg);
        const auto end = map.end();
        if (leftPtr != end && rightPtr != end)
                return make_bad<MapIt>("Duplicate option: " + name);
        if (leftPtr != end)
                return leftPtr;
        if (rightPtr != end)
                return rightPtr;
        return end;
}
