/**
 * File: UtilAssemblerFunctions.hh
 * Copyright (C) 2025 Tyler Triplett
 * License: GNU GPL 3.0 or later <https://www.gnu.org/licenses/gpl-3.0.html>
 *
 * This is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 */

#include "src/List.hh"
#include "src/types.hh"

#ifndef UTIL_ASSEMBLER_FUNCTIONS_HH
#define UTIL_ASSEMBLER_FUNCTIONS_HH

using FilesL = ty::List<std::string>;

class UtilAssemblerFunctions {
protected:
        Error writeStripe(FilesL files, std::ofstream& out) const;
public:
        UtilAssemblerFunctions() { }
        virtual ~UtilAssemblerFunctions() { }
        UtilAssemblerFunctions(const UtilAssemblerFunctions&) = delete;
};

#endif /// UTIL_ASSEMBLER_FUNCTIONS_HH
